/*
 * Created on Aug 12, 2003
 */
package DatabaseCommunication;

import java.sql.*;
import java.io.*;
import java.util.*;

/**
 * @author student
 *
 * Class Information:
 * Class : DatabaseConnection.java
 * Package : DatabaseCommunication
 * Project: Pinboard
 * This class is being used for
 * 
 */
public class DatabaseConnection {

	//	static String url = "jdbc:mysql://172.21.5.26:3306/test";
	static Connection con;

	/**
	 * This is the constructor for DatabaseConnection.java
	 */
	public DatabaseConnection() {
		try {
			Properties p = new Properties();
			p.load(new FileInputStream("configuration.txt"));
			String url = p.getProperty("MYSQLURL");
			//String url = "//jdbc:mysql://127.0.0.1:3306/stocktrading?user=root;password=";
			Class.forName("com.mysql.jdbc.Driver").newInstance();
			con = DriverManager.getConnection(url, "root", "password");
			Class.forName("com.mysql.jdbc.Driver").newInstance();
			System.out.println("Now connected to the Pinboard database.");

		} catch (Exception e) {
			System.out.println("Database Exception : " + e.toString());
		}

	}
	/**
	 * Method: createTables
	 * This method is being used for
	 * @param statement void
	 */
	public void createTables(String statement) {
		try {
			System.out.println("1");
			Statement s = con.createStatement();
			System.out.println("2");
			s.executeUpdate(statement);
			System.out.println("3");
			s.close();
			System.out.println("Successful");
		} catch (Exception e) {
			System.out.println(
				"Error occured while creating Table " + statement);
			System.out.println("Exception " + e.toString());
		}
	}
	/**
	 * Method: destroyTables
	 * This method is being used for
	 * @param statement void
	 */
	public void destroyTables(String statement) {
		try {
			Statement s = con.createStatement();
			s.executeUpdate(statement);
			s.close();
			System.out.println("Successful");
		} catch (Exception e) {
			System.out.println(
				"Error occured while deleting Table" + statement);

		}
	}
	/**
	 * Method: executeSelect
	 * This method is being used for
	 * @param statement
	 * @return ResultSet
	 */
	public ResultSet executeSelect(String statement) {
		try {
			Statement s = con.createStatement();
			ResultSet rs = s.executeQuery(statement);
			System.out.println("Successful");
			return rs;
		} catch (Exception e) {
			System.out.println(
				"Error occured while executing statement" + statement);
			System.out.println("Exception " + e.toString());
			return null;
		}
	}

	/**
	 * Method: execute
	 * This method is being used for
	 * @param statement void
	 */
	public void execute(String statement) {
		try {
			Statement s = con.createStatement();
			s.executeUpdate(statement);
			s.close();
			System.out.println("Successful");
		} catch (Exception e) {
			System.out.println(
				"Error occured while executing statement" + statement);
			System.out.println("Exception " + e.toString());
		}
	}
	/**
	 * Method: getConnection
	 * This method is being used for
	 * @return Connection
	 */
	public Connection getConnection() {
		return con;
	}
	//public void setConnection(Connection con) { this.con = con; }	
}
